package co.simplon.springboot.actor;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import java.sql.Timestamp;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import co.simplon.springboot.actor.dao.ActorDAO;
import co.simplon.springboot.actor.model.Actor;
import co.simplon.springboot.actor.service.ActorService;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = ActorApplication.class)
public class ActorJdbcTest {

	static ActorService actorSce;

	@Autowired
	@Qualifier("jdbcActorDAO")
	ActorDAO actorDAO;

	@BeforeClass
	public static void initActor() throws Exception {
		actorSce = new ActorService();
	}

	@Test
	public void testFindOneOk() {

		// Instanciez un objet actor
		// Affectez lui un objet actor ayant l'identifiant 6
		// Verifiez avec un assertEquals si le firstName est bien égale à Jennifer
		
	}

	@Test
	public void testFindOneKo() {
	    // Instanciez un objet actor
		// Affectez lui un objet actor ayant l'identifiant 999
        //  Verifiez avec un assertNull que l'actor est bien null !
    }

	@Test
	public void testFindOneBisOk() {

        // Instanciez un objet actor
		// Affectez lui un objet actor ayant l'identifiant 1
        // Utilisez assertThat pour verifier que l'objet actor récupéré est bien une instance de la classe Actor
    }

	@Test
	public void testInsert() {

        // Instanciez 2 objets un actor et un actorNew à null
		// pour le premier actor, affectez lui un mock en utilisant la méthode privée createMock("Jean", "saisrien")
        // pour le second le actorNew, utilisez la méthode insertActor() en lui passant actor en paramètre
        // Utilisez assertTrue pour verifier que actorNew est différent de null
	}

	@Test
	public void testUpdate() {

         // Instanciez 2 objets un actor et un actorNew à null
         // Affectez les valeurs suivantes à actor : Jack Ouille id = 2
         // pour le timestamp : actor.setLastUpdate(new Timestamp(System.currentTimeMillis()));
         // Initialisez actorNew en utilisant la méthode updateActor() en lui passant actor en paramètre.
         // ajoutez 2  assertions, l'une pour vérifier que actorNew n'est pas null
         // la seconde pour vérifier que "Jack" est bien le firstName de actorNew.

	}
	
	@Test
	public void testDelete() {

        // Instanciez un objet actor avec le constructeur sans argument
		// Déclarez une variable Long id avec la valeur 3
		// Utilisez la méthode deleterActor() pour effacer l'actor avec l'id = 3
        // essayez de récupérer un actor avec l'id = 3
	}

    /**
    *   Méthode privée de création d'un mock
    **/
	private Actor createMock(String firstName, String lastName) {
		Actor mock = new Actor();
		mock.setFirstName(firstName);
		mock.setLastName(lastName);
		mock.setId(new Long(0));
		mock.setLastUpdate(new Timestamp(System.currentTimeMillis()));
		return mock;
	}

}